<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <?php
        use Illuminate\Support\Facades\Storage;
        
        // Menggunakan fallback jika settings belum dimuat
        $settings = $settings ?? \App\Models\Setting::pluck('value', 'key')->toArray(); 
        $schoolName = $settings['school_name'] ?? config('app.name', 'E-Absensi');
        $schoolLogoPath = $settings['school_logo'] ?? 'default/favicon.ico'; 
        
        // --- LOGIKA PATH FAVICON/LOGO ---
        $faviconUrl = asset('images/default/favicon.ico'); 
        
        // 🔥 PERBAIKAN: Gunakan path default yang lebih aman jika path DB kosong
        if (!empty($schoolLogoPath) && $schoolLogoPath != 'default/favicon.ico' && Storage::disk('public')->exists($schoolLogoPath)) {
            $faviconUrl = asset('storage/' . $schoolLogoPath);
        }
    ?>
    
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($schoolName); ?></title>

    
    <link rel="icon" href="<?php echo e($faviconUrl); ?>" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo e($faviconUrl); ?>" type="image/x-icon">

    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
    
    
    <link rel="stylesheet" href="<?php echo e(asset('template/adminlte/plugins/fontawesome-free/css/all.min.css')); ?>">
    
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?> 

    
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    
    <?php echo $__env->yieldPushContent('css'); ?>

</head>
<body class="bg-gray-50 font-sans text-gray-900 antialiased">
    
    
    <?php echo $__env->make('layouts.partials.loader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    <?php echo $__env->yieldContent('content'); ?>
    
    
    <script src="<?php echo e(asset('template/adminlte/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('template/adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    
    
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800,
            once: true,
        });
    </script>
    
    
    <?php echo $__env->yieldContent('js'); ?>

</body>
</html><?php /**PATH C:\xampp\htdocs\e-absensi-siswa\resources\views/layouts/guest.blade.php ENDPATH**/ ?>